/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.Level;
import vazkii.botania.api.mana.ILens;
import vazkii.botania.api.mana.ILensControl;
import vazkii.botania.common.item.ItemManaGun;

public class ManaGunLensRecipe
extends CustomRecipe {
    public static final SimpleRecipeSerializer<ManaGunLensRecipe> SERIALIZER = new SimpleRecipeSerializer(ManaGunLensRecipe::new);

    public ManaGunLensRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(@Nonnull CraftingContainer inv, @Nonnull Level world) {
        boolean foundLens = false;
        boolean foundGun = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            Item item;
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (!foundGun && stack.m_41720_() instanceof ItemManaGun && ItemManaGun.getLens(stack).m_41619_()) {
                foundGun = true;
                continue;
            }
            if (!foundLens && (item = stack.m_41720_()) instanceof ILens) {
                ILensControl control;
                ILens lens = (ILens)item;
                if (!(lens instanceof ILensControl) || !(control = (ILensControl)lens).isControlLens(stack)) {
                    foundLens = true;
                    continue;
                }
                return false;
            }
            return false;
        }
        return foundLens && foundGun;
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer inv) {
        ItemStack lens = ItemStack.f_41583_;
        ItemStack gun = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof ItemManaGun) {
                gun = stack;
                continue;
            }
            if (!(stack.m_41720_() instanceof ILens)) continue;
            lens = stack.m_41777_();
            lens.m_41764_(1);
        }
        if (lens.m_41619_() || gun.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack gunCopy = gun.m_41777_();
        ItemManaGun.setLens(gunCopy, lens);
        return gunCopy;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }
}

